/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.animal.LOTREntityCamel;
import lotr.common.entity.npc.LOTREntityNearHaradrimBase;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.item.LOTRItemHaradRobes;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.biome.LOTRBiomeGenNearHarad;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityNomad
extends LOTREntityNearHaradrimBase
implements LOTRBiomeGenNearHarad.ImmuneToHeat {
    protected static int[] nomadTurbanColors = new int[]{15392448, 13550476, 10063441, 8354400, 8343622};

    public LOTREntityNomad(World world) {
        super(world);
        this.addTargetTasks(false);
    }

    @Override
    protected LOTRFoods getHaradrimFoods() {
        return LOTRFoods.NOMAD;
    }

    @Override
    protected LOTRFoods getHaradrimDrinks() {
        return LOTRFoods.NOMAD_DRINK;
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getNomadName(this.field_70146_Z, this.familyInfo.isMale()));
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.daggerHarad));
        this.npcItemsInv.setIdleItem(null);
        if (this.field_70146_Z.nextInt(4) == 0) {
            ItemStack turban = new ItemStack(LOTRMod.helmetHaradRobes);
            int robeColor = nomadTurbanColors[this.field_70146_Z.nextInt(nomadTurbanColors.length)];
            LOTRItemHaradRobes.setRobesColor(turban, robeColor);
            this.func_70062_b(4, turban);
        } else {
            this.func_70062_b(4, null);
        }
        return data;
    }

    @Override
    public LOTRNPCMount createMountToRide() {
        LOTREntityCamel camel = new LOTREntityCamel(this.field_70170_p);
        camel.setNomadChestAndCarpet();
        return camel;
    }

    @Override
    protected void dropHaradrimItems(boolean flag, int i) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.dropChestContents(LOTRChestContents.NOMAD_TENT, 1, 2 + i);
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killNearHaradrim;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "nearHarad/nomad/nomad/friendly";
        }
        return "nearHarad/nomad/nomad/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.NOMAD.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.NOMAD;
    }
}

